package com.hero.ui.dialog;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import com.hero.HeroDesigner;
import com.hero.Rules;
import com.hero.model.DoubleDocument;
import com.hero.objects.GenericObject;
import com.hero.objects.characteristics.Characteristic;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class RulesDialog extends JDialog {

	private static final long serialVersionUID = -4461617275751042646L;

	private JLabel basePointsLbl;

	private LevelTF basePointsTF;

	private JLabel disadPointsLbl;

	private LevelTF disadPointsTF;

	private JLabel attackAPMaxValueLbl;

	private LevelTF attackAPMaxValueTF;

	private JLabel attackAPMaxResponseLbl;

	private JComboBox attackAPMaxResponseCombo;

	private JLabel availDisadPointsResponseLbl;

	private JComboBox availDisadPointsResponseCombo;

	private JLabel availTotalPointsResponseLbl;

	private JComboBox availTotalPointsResponseCombo;

	private JLabel defenseAPMaxResponseLbl;

	private JComboBox defenseAPMaxResponseCombo;

	private JLabel defenseAPMaxValueLbl;

	private LevelTF defenseAPMaxValueTF;

	private JLabel disadCategoryMaxResponseLbl;

	private JComboBox disadCategoryMaxResponseCombo;

	private JLabel disadCategoryMaxValueLbl;

	private LevelTF disadCategoryMaxValueTF;

	private JLabel maneuverMaxResponseLbl;

	private JComboBox maneuverMaxResponseCombo;

	private JLabel maneuverMaxValueLbl;

	private LevelTF maneuverMaxValueTF;

	private JLabel perkMaxResponseLbl;

	private JComboBox perkMaxResponseCombo;

	private JLabel perkMaxValueLbl;

	private LevelTF perkMaxValueTF;

	private JLabel powerMaxResponseLbl;

	private JComboBox powerMaxResponseCombo;

	private JLabel powerMaxValueLbl;

	private LevelTF powerMaxValueTF;

	private JLabel skillMaxResponseLbl;

	private JComboBox skillMaxResponseCombo;

	private JLabel skillMaxValueLbl;

	private LevelTF skillMaxValueTF;

	private JLabel talentMaxResponseLbl;

	private JComboBox talentMaxResponseCombo;

	private JLabel talentMaxValueLbl;

	private LevelTF talentMaxValueTF;

	private JLabel apPerENDLbl;

	private LevelTF apPerENDTF;

	private JLabel strApPerENDLbl;

	private LevelTF strApPerENDTF;

	private JCheckBox equipmentAllowedCB;

	private JCheckBox ncmSelectedCB;

	private JCheckBox ncmUserChangeableCB;

	private JPanel equipmentPanel;

	private JLabel equipmentCostConversionLbl;

	private JTextField equipmentCostConversionTF;

	private LevelTF equipmentCostDecimalPlacesTF;

	private JLabel equipmentCostDecimalPlacesLbl;

	private JLabel equipmentCostUnitsLbl;

	private JTextField equipmentCostUnitsTF;

	private JCheckBox equipmentUnitsPrefixCB;

	private JLabel equipmentCostValueLbl;

	private LevelTF equipmentCostValueTF;

	private JLabel equipmentCostResponseLbl;

	private JComboBox equipmentCostResponseCombo;

	private JLabel equipmentCostExampleLbl;

	private JPanel skillsPanel;
	private JCheckBox useSkillMaximaCB;
	private JLabel skillMaximaLimitLbl;
	private LevelTF skillMaximaLimitTF;
	private JCheckBox useSkillMultiplierCB;

	private JPanel languageFamiliarityPanel;

	private JCheckBox useLanguageFamiliarityChartCB;

	private JCheckBox penalizeNoLevel1SimilarityCB;

	private JCheckBox literacyFreeCB;

	private JCheckBox nativeLiteracyFreeCB;
	
	private JCheckBox languagesAsINTSkillCB;

	private JPanel characteristicsPanel;

	private JCheckBox onlySellOneFiguredCB;

	private JCheckBox useIncreasedDamageDifferentiationCB;

	private JPanel frameworksPanel;

	private JLabel linkAcrossFrameworkLbl;

	private JComboBox linkAcrossFrameworkCombo;

	private JLabel specialTypeInFrameworkLbl;

	private JComboBox specialTypeInFrameworkCombo;

	private JLabel nonENDUsingAbilityInECLbl;

	private JComboBox nonENDUsingAbilityInECCombo;

	private JCheckBox automaticallyApplyNoFiguredCB;

	private JPanel standardEffectPanel;

	private JCheckBox standardEffectAllowedCB;

	private JCheckBox defaultStandardEffectCB;

	private JPanel powersPanel;

	private JCheckBox useExpandedGrowthChartCB;

	private JPanel generalPanel;

	private JCheckBox multiplierAllowedCB;

	private JPanel notesPanel;

	private JCheckBox useNotes1CB;

	private JTextField notes1LabelTF;

	private JCheckBox useNotes2CB;

	private JTextField notes2LabelTF;

	private JCheckBox useNotes3CB;

	private JTextField notes3LabelTF;

	private JCheckBox useNotes4CB;

	private JTextField notes4LabelTF;

	private JCheckBox useNotes5CB;

	private JTextField notes5LabelTF;

	private Rules rules;

	private JButton saveBtn;

	private JButton saveAsBtn;

	private JButton cancelBtn;

	private boolean cancelButtonClicked = false;

	private JLabel nameLbl;

	private JTextField nameTF;
	
	private JLabel skillRollCalculationBaseLbl;
	private LevelTF skillRollCalculationBaseTF;
	private JLabel skillRollCalculationDenominatorLbl;
	private LevelTF skillRollCalculationDenominatorTF;
	
	private JLabel charRollCalculationBaseLbl;
	private LevelTF charRollCalculationBaseTF;
	private JLabel charRollCalculationDenominatorLbl;
	private LevelTF charRollCalculationDenominatorTF;

	public RulesDialog() {
		super(HeroDesigner.getAppFrame(), "View/Edit Rules", true);
		rules = HeroDesigner.getInstance().getActiveHero().getRules();
		init();
		pack();
	}

	/**
	 * Returns true if the user clicked the cancel button.
	 * 
	 * @return
	 */
	public boolean cancelButtonClicked() {
		return cancelButtonClicked;
	}

	private void init() {
		JPanel pointLimits = new JPanel(new GridBagLayout());
		JPanel settings = new JPanel(new GridBagLayout());
		JPanel rulesPanel = new JPanel(new GridBagLayout());
		JPanel charMax = new JPanel(new GridBagLayout());
		JTabbedPane tabPane = new JTabbedPane();
		tabPane.add("Point Limits", new JScrollPane(pointLimits));
		if (HeroDesigner.getActiveTemplate().is6E()) {
			tabPane.add("Characteristic Maxima", new JScrollPane(charMax));
		}
		tabPane.add("Rules", new JScrollPane(rulesPanel));
		tabPane.add("Settings", new JScrollPane(settings));

		saveBtn = new JButton("Save");
		saveAsBtn = new JButton("Save As...");
		cancelBtn = new JButton("Cancel");
		saveBtn.setEnabled(!rules.isDefault());

		saveBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.saveRulesDefinition(rules.getCurrentSet());
				HeroDesigner.getActiveHero().setBasePoints(
						rules.getBasePoints());
				HeroDesigner.getActiveHero().setDisadPoints(
						rules.getDisadPoints());
				setVisible(false);
				cancelButtonClicked = false;
			}
		});

		saveAsBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				chooser.setFileFilter(new javax.swing.filechooser.FileFilter() {
					public boolean accept(File file) {
						if (file.isDirectory()) {
							return true;
						}
						if (file.getName().toUpperCase().endsWith(".HDR")) {
							return true;
						} else {
							return false;
						}
					}

					public String getDescription() {
						return "Hero Designer Campaign Rules Files";
					}
				});
				chooser.setApproveButtonText("Save Rules");
				chooser.setDialogTitle("Save Campaign Rules");
				chooser.setFileSelectionMode(chooser.FILES_ONLY);
				chooser.setMultiSelectionEnabled(false);
				chooser.setAcceptAllFileFilterUsed(false);
				chooser.setCurrentDirectory(new File(HeroDesigner.getInstance()
						.getPrefs().getRulesDir()));
				// if (prefs.getSaveDir() != null &&
				// prefs.getSaveDir().trim().length() > 0) {
				// try {
				// hdzChooser.setCurrentDirectory(new
				// File(prefs.getSaveDir()));
				// }
				// catch (Exception ex) {
				// }
				// }
				if (!rules.getCurrentSet().equals("Default")) {
					String name = rules.getCurrentSet();
					String part1 = name.substring(0, name.lastIndexOf("."));
					String file = part1 + ".hdr";
					chooser.setSelectedFile(new File(file));
				}
				File saveFile = null;
				while (saveFile == null) {
					int ret = chooser.showSaveDialog(RulesDialog.this);
					if (ret == chooser.CANCEL_OPTION) {
						return;
					} else if (ret == chooser.APPROVE_OPTION) {
						saveFile = chooser.getSelectedFile();
						HeroDesigner.getInstance().getPrefs().setRulesDir(
								saveFile.getParent());
						String name = saveFile.getName();
						if (name.indexOf(".") < 0) {
							name = name + ".hdr";
						} else {
							String ext = name.substring(name.lastIndexOf("."),
									name.length());
							if (!ext.equalsIgnoreCase(".hdr")) {
								name = name.substring(0, name.lastIndexOf("."));
								name = name + ".hdr";
							}
						}
						if (!name.equals(saveFile.getName())) {
							String path = "";
							if (saveFile.getParentFile() != null) {
								path = saveFile.getParent();
								if (!path.endsWith(saveFile.separator)) {
									path = path + saveFile.separator;
								}
							}
							saveFile = new File(path + name);
						}
						if (saveFile.exists()) {
							int response = JOptionPane.showConfirmDialog(
									RulesDialog.this, saveFile.getName()
											+ " already exists.\n\nOverwrite?");
							if (response == JOptionPane.CANCEL_OPTION) {
								return;
							} else if (response == JOptionPane.NO_OPTION) {
								saveFile = null;
							}
						}
					}
				}
				HeroDesigner.getInstance().getPrefs().setRulesDir(
						saveFile.getParent());
				HeroDesigner.getInstance().getPrefs().setLastRule(
						saveFile.getAbsolutePath());
				rules.saveRulesDefinition(saveFile.getAbsolutePath());
				HeroDesigner.getActiveHero().setBasePoints(
						rules.getBasePoints());
				HeroDesigner.getActiveHero().setDisadPoints(
						rules.getDisadPoints());
				cancelButtonClicked = false;
				setVisible(false);
			}
		});

		cancelBtn.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (rules.getCurrentSet().equals("Default")) {
					rules.useDefault();
				} else {
					rules.loadRulesDefinition(rules.getCurrentSet());
				}
				cancelButtonClicked = true;
				setVisible(false);
			}
		});

		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(saveBtn);
		buttons.add(saveAsBtn);
		buttons.add(cancelBtn);

		JPanel main = new JPanel(new BorderLayout());

		nameLbl = new JLabel("<html><b>Ruleset Name:</b></html>");
		nameTF = new JTextField(rules.getName());
		nameTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				rules.setName(nameTF.getText().trim());
			}

			public void insertUpdate(DocumentEvent e) {
				rules.setName(nameTF.getText().trim());
			}

			public void removeUpdate(DocumentEvent e) {
				rules.setName(nameTF.getText().trim());
			}
		});
		JPanel namePanel = new JPanel(new BorderLayout());
		namePanel.add(nameLbl, "West");
		namePanel.add(nameTF, "Center");

		main.add(namePanel, "North");
		main.add(tabPane, "Center");
		main.add(buttons, "South");

		setContentPane(main);

		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.fill = gbc.HORIZONTAL;
		gbc.anchor = gbc.WEST;
		gbc.insets = new Insets(2, 5, 2, 5);

		if (HeroDesigner.getActiveTemplate().is6E()) {
			// CHARACTERISTIC MAXIMA
			JPanel maxPanel = new JPanel(new GridBagLayout());
			maxPanel.setBorder(BorderFactory
					.createTitledBorder("Maximum Value Before Cost Doubles"));
			gbc.fill = gbc.BOTH;
			charMax.add(maxPanel, gbc);
			gbc.fill = gbc.HORIZONTAL;
			gbc.weighty = 0;
			ArrayList<GenericObject> chars = HeroDesigner.getActiveTemplate()
					.getCharacteristics();
			for (GenericObject go : chars) {
				Characteristic c = (Characteristic) go;
				int cur = rules.getCharacteristicMaxima(c.getXMLID());
				gbc.fill = gbc.NONE;
				gbc.anchor = gbc.EAST;
				gbc.weightx = 0;
				maxPanel.add(new JLabel(c.getDisplay()), gbc);
				gbc.gridx = 1;
				gbc.weightx = 1;
				gbc.anchor = gbc.WEST;
				LevelTF tf = new LevelTF(cur, 999, 0);
				tf.setTrackObject(c);
				tf.addPropertyChangeListener("Level",
						new PropertyChangeListener() {
							public void propertyChange(PropertyChangeEvent e) {
								if (!e.getOldValue().equals(e.getNewValue())) {
									LevelTF tf = (LevelTF) e.getSource();
									Characteristic c = (Characteristic) tf
											.getTrackObject();
									System.out.println("Setting for "
											+ c.getDisplay() + " val = "
											+ e.getNewValue());
									rules.setCharacteristicMaxima(c,
											(Integer) e.getNewValue());
								}
							}
						});
				maxPanel.add(tf, gbc);
				gbc.gridy++;
				gbc.gridx = 0;
			}
		}

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0;
		gbc.weighty = 1;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		gbc.insets = new Insets(2, 5, 2, 5);

		// AP USAGE
		JPanel panel1 = new JPanel(new GridBagLayout());
		apPerENDLbl = new JLabel("Active Points per END:");
		apPerENDTF = new LevelTF(rules.getAPPerEND(), 999999, 0);
		apPerENDTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setAPPerEND(apPerENDTF.getCurrent());
					}
				});
		panel1.add(apPerENDLbl, gbc);
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.anchor = gbc.WEST;
		panel1.add(apPerENDTF, gbc);
		gbc.gridx = 0;
		gbc.weightx = 0;
		gbc.anchor = gbc.EAST;
		gbc.gridy++;
		strApPerENDLbl = new JLabel("Active Points per END (STR):");
		strApPerENDTF = new LevelTF(rules.getSTRAPPerEND(), 999999, 0);
		strApPerENDTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setSTRAPPerEND(strApPerENDTF.getCurrent());
					}
				});
		panel1.add(strApPerENDLbl, gbc);
		gbc.gridx = 1;
		gbc.weightx = 1;
		gbc.anchor = gbc.WEST;
		panel1.add(strApPerENDTF, gbc);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = gbc.REMAINDER;
		gbc.gridheight = 1;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.WEST;
		gbc.insets = new Insets(2, 5, 2, 5);
		settings.add(panel1, gbc);
		gbc.gridy++;

		if (HeroDesigner.getActiveTemplate().is6E()) {

		} else {
			// NCM SELECTED
			ncmSelectedCB = new JCheckBox("NCM Selected");
			ncmSelectedCB.setSelected(rules.isNCMSelected());
			ncmSelectedCB.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					rules.setNCMSelected(ncmSelectedCB.isSelected());
				}
			});
			settings.add(ncmSelectedCB, gbc);
			gbc.gridy++;
			gbc.weightx = 0;
			gbc.weighty = 0;
			gbc.gridwidth = gbc.REMAINDER;
			gbc.fill = gbc.NONE;
			gbc.gridx = 0;

			// NCM USER CHANGEABLE
			ncmUserChangeableCB = new JCheckBox("User can change NCM selection");
			ncmUserChangeableCB.setSelected(rules.isNCMUserChangeable());
			ncmUserChangeableCB.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					rules
							.setNCMUserChangeable(ncmUserChangeableCB
									.isSelected());
				}
			});
			settings.add(ncmUserChangeableCB, gbc);
			gbc.gridy++;
			gbc.weightx = 0;
			gbc.weighty = 0;
			gbc.gridwidth = gbc.REMAINDER;
			gbc.fill = gbc.NONE;
			gbc.gridx = 0;

		}

		// EQUIPMENT ALLOWED
		equipmentPanel = new JPanel(new GridBagLayout());
		equipmentPanel.setBorder(BorderFactory.createTitledBorder("Equipment"));
		equipmentAllowedCB = new JCheckBox("Equipment Allowed");
		equipmentAllowedCB.setSelected(rules.isEquipmentAllowed());
		equipmentAllowedCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setEquipmentAllowed(equipmentAllowedCB.isSelected());
				equipmentCostValueLbl.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostValueTF
						.setEnabled(equipmentAllowedCB.isSelected());
				equipmentCostResponseLbl.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostResponseCombo.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostUnitsLbl.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostUnitsTF
						.setEnabled(equipmentAllowedCB.isSelected());
				equipmentUnitsPrefixCB.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostConversionLbl.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostConversionTF.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostDecimalPlacesLbl.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostDecimalPlacesTF.setEnabled(equipmentAllowedCB
						.isSelected());
				equipmentCostExampleLbl.setEnabled(equipmentAllowedCB
						.isSelected());
			}
		});
		equipmentPanel.add(equipmentAllowedCB, gbc);
		gbc.gridy++;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.fill = gbc.NONE;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;

		equipmentCostUnitsLbl = new JLabel("Monetary Units:");
		equipmentPanel.add(equipmentCostUnitsLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		equipmentCostUnitsTF = new JTextField(rules.getEquipmentCostUnits(), 12);
		equipmentCostUnitsTF.getDocument().addDocumentListener(
				new DocumentListener() {
					public void changedUpdate(DocumentEvent e) {
						rules.setEquipmentCostUnits(equipmentCostUnitsTF
								.getText());
						setEquipmentCostExample();
					}

					public void insertUpdate(DocumentEvent e) {
						rules.setEquipmentCostUnits(equipmentCostUnitsTF
								.getText());
						setEquipmentCostExample();
					}

					public void removeUpdate(DocumentEvent e) {
						rules.setEquipmentCostUnits(equipmentCostUnitsTF
								.getText());
						setEquipmentCostExample();
					}
				});
		equipmentPanel.add(equipmentCostUnitsTF, gbc);
		gbc.gridx++;
		gbc.anchor = gbc.WEST;
		gbc.weightx = 1;
		gbc.gridwidth = gbc.REMAINDER;
		equipmentUnitsPrefixCB = new JCheckBox("Prepend unit string to value");
		equipmentUnitsPrefixCB.setSelected(rules.isEquipmentUnitsPrefix());
		equipmentUnitsPrefixCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setEquipmentUnitsPrefix(equipmentUnitsPrefixCB
						.isSelected());
				setEquipmentCostExample();
			}
		});
		equipmentPanel.add(equipmentUnitsPrefixCB, gbc);
		gbc.gridy++;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		gbc.gridx = 0;

		equipmentCostConversionLbl = new JLabel(rules.getEquipmentCostUnits()
				+ " per 1 CU:");
		equipmentPanel.add(equipmentCostConversionLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		equipmentCostConversionTF = new JTextField(new DoubleDocument(
				999999999999999d, 0), "" + rules.getEquipmentCostConversion(),
				12);
		equipmentCostConversionTF.getDocument().addDocumentListener(
				new DocumentListener() {
					public void changedUpdate(DocumentEvent e) {
						if (equipmentCostConversionTF.getText().trim().length() == 0) {
							rules.setEquipmentCostConversion(1d);
							setEquipmentCostExample();
							return;
						}
						rules.setEquipmentCostConversion(Double
								.parseDouble(equipmentCostConversionTF
										.getText()));
						setEquipmentCostExample();
					}

					public void insertUpdate(DocumentEvent e) {
						if (equipmentCostConversionTF.getText().trim().length() == 0) {
							rules.setEquipmentCostConversion(1d);
							setEquipmentCostExample();
							return;
						}
						rules.setEquipmentCostConversion(Double
								.parseDouble(equipmentCostConversionTF
										.getText()));
						setEquipmentCostExample();
					}

					public void removeUpdate(DocumentEvent e) {
						if (equipmentCostConversionTF.getText().trim().length() == 0) {
							rules.setEquipmentCostConversion(1d);
							setEquipmentCostExample();
							return;
						}
						rules.setEquipmentCostConversion(Double
								.parseDouble(equipmentCostConversionTF
										.getText()));
						setEquipmentCostExample();
					}
				});
		equipmentPanel.add(equipmentCostConversionTF, gbc);
		equipmentCostDecimalPlacesLbl = new JLabel("decimal places:");
		gbc.gridx = 2;
		gbc.anchor = gbc.EAST;
		equipmentPanel.add(equipmentCostDecimalPlacesLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		gbc.weightx = 1;
		equipmentCostDecimalPlacesTF = new LevelTF(rules
				.getEquipmentCostDecimalPlaces(), 6, 0);
		equipmentCostDecimalPlacesTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules
								.setEquipmentCostDecimalPlaces(equipmentCostDecimalPlacesTF
										.getCurrent());
						setEquipmentCostExample();
					}
				});
		equipmentPanel.add(equipmentCostDecimalPlacesTF, gbc);

		gbc.gridy++;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = gbc.REMAINDER;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.WEST;
		gbc.gridx = 0;
		equipmentCostExampleLbl = new JLabel();
		setEquipmentCostExample();
		gbc.insets = new Insets(2, 30, 2, 5);
		equipmentPanel.add(equipmentCostExampleLbl, gbc);

		gbc.insets = new Insets(2, 5, 2, 5);
		gbc.gridy++;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = gbc.REMAINDER;
		gbc.fill = gbc.HORIZONTAL;
		gbc.anchor = gbc.WEST;
		gbc.gridx = 0;
		settings.add(equipmentPanel, gbc);

		// NOTES
		useNotes1CB = new JCheckBox();
		useNotes1CB.setSelected(rules.useNotes1());
		useNotes1CB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseNotes1(useNotes1CB.isSelected());
				notes1LabelTF.setEnabled(useNotes1CB.isSelected());
			}
		});
		notes1LabelTF = new JTextField(rules.getNotes1Label());
		notes1LabelTF.setEnabled(rules.useNotes1());
		notes1LabelTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				rules.setNotes1Label(notes1LabelTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				rules.setNotes1Label(notes1LabelTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				rules.setNotes1Label(notes1LabelTF.getText());
			}
		});
		useNotes2CB = new JCheckBox();
		useNotes2CB.setSelected(rules.useNotes2());
		useNotes2CB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseNotes2(useNotes2CB.isSelected());
				notes2LabelTF.setEnabled(useNotes2CB.isSelected());
			}
		});
		notes2LabelTF = new JTextField(rules.getNotes2Label());
		notes2LabelTF.setEnabled(rules.useNotes2());
		notes2LabelTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				rules.setNotes2Label(notes2LabelTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				rules.setNotes2Label(notes2LabelTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				rules.setNotes2Label(notes2LabelTF.getText());
			}
		});
		useNotes3CB = new JCheckBox();
		useNotes3CB.setSelected(rules.useNotes3());
		useNotes3CB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseNotes3(useNotes3CB.isSelected());
				notes3LabelTF.setEnabled(useNotes3CB.isSelected());
			}
		});
		notes3LabelTF = new JTextField(rules.getNotes3Label());
		notes3LabelTF.setEnabled(rules.useNotes3());
		notes3LabelTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				rules.setNotes3Label(notes3LabelTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				rules.setNotes3Label(notes3LabelTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				rules.setNotes3Label(notes3LabelTF.getText());
			}
		});
		useNotes4CB = new JCheckBox();
		useNotes4CB.setSelected(rules.useNotes4());
		useNotes4CB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseNotes4(useNotes4CB.isSelected());
				notes4LabelTF.setEnabled(useNotes4CB.isSelected());
			}
		});
		notes4LabelTF = new JTextField(rules.getNotes4Label());
		notes4LabelTF.setEnabled(rules.useNotes4());
		notes4LabelTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				rules.setNotes4Label(notes4LabelTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				rules.setNotes4Label(notes4LabelTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				rules.setNotes4Label(notes4LabelTF.getText());
			}
		});
		useNotes5CB = new JCheckBox();
		useNotes5CB.setSelected(rules.useNotes5());
		useNotes5CB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseNotes5(useNotes5CB.isSelected());
				notes5LabelTF.setEnabled(useNotes5CB.isSelected());
			}
		});
		notes5LabelTF = new JTextField(rules.getNotes5Label());
		notes5LabelTF.setEnabled(rules.useNotes5());
		notes5LabelTF.getDocument().addDocumentListener(new DocumentListener() {
			public void changedUpdate(DocumentEvent e) {
				rules.setNotes5Label(notes5LabelTF.getText());
			}

			public void insertUpdate(DocumentEvent e) {
				rules.setNotes5Label(notes5LabelTF.getText());
			}

			public void removeUpdate(DocumentEvent e) {
				rules.setNotes5Label(notes5LabelTF.getText());
			}
		});
		notesPanel = new JPanel(new GridBagLayout());
		notesPanel.setBorder(BorderFactory.createTitledBorder("Notes Tabs"));
		notesPanel.add(new JLabel("Enabled"), new GridBagConstraints(1, 0, 1,
				1, 0, 0, GridBagConstraints.EAST, GridBagConstraints.NONE,
				new Insets(3, 3, 3, 3), 0, 0));
		notesPanel.add(new JLabel("Tab Title"), new GridBagConstraints(0, 0, 1,
				1, 1, 0, GridBagConstraints.WEST, GridBagConstraints.NONE,
				new Insets(3, 3, 3, 3), 0, 0));
		notesPanel.add(useNotes1CB, new GridBagConstraints(1, 1, 1, 1, 0, 0,
				GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3,
						3, 3, 3), 0, 0));
		notesPanel.add(notes1LabelTF, new GridBagConstraints(0, 1, 1, 1, 1, 0,
				GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
				new Insets(3, 3, 3, 3), 0, 0));
		notesPanel.add(useNotes2CB, new GridBagConstraints(1, 2, 1, 1, 0, 0,
				GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3,
						3, 3, 3), 0, 0));
		notesPanel.add(notes2LabelTF, new GridBagConstraints(0, 2, 1, 1, 1, 0,
				GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
				new Insets(3, 3, 3, 3), 0, 0));
		notesPanel.add(useNotes3CB, new GridBagConstraints(1, 3, 1, 1, 0, 0,
				GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3,
						3, 3, 3), 0, 0));
		notesPanel.add(notes3LabelTF, new GridBagConstraints(0, 3, 1, 1, 1, 0,
				GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
				new Insets(3, 3, 3, 3), 0, 0));
		notesPanel.add(useNotes4CB, new GridBagConstraints(1, 4, 1, 1, 0, 0,
				GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3,
						3, 3, 3), 0, 0));
		notesPanel.add(notes4LabelTF, new GridBagConstraints(0, 4, 1, 1, 1, 0,
				GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
				new Insets(3, 3, 3, 3), 0, 0));
		notesPanel.add(useNotes5CB, new GridBagConstraints(1, 5, 1, 1, 0, 0,
				GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(3,
						3, 3, 3), 0, 0));
		notesPanel.add(notes5LabelTF, new GridBagConstraints(0, 5, 1, 1, 1, 0,
				GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
				new Insets(3, 3, 3, 3), 0, 0));

		gbc.insets = new Insets(2, 5, 2, 5);
		gbc.gridy++;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = gbc.REMAINDER;
		gbc.fill = gbc.HORIZONTAL;
		gbc.anchor = gbc.WEST;
		gbc.gridx = 0;
		settings.add(notesPanel, gbc);

		// SETTINGS FILLER
		gbc.gridy++;
		gbc.weightx = 1;
		gbc.weighty = 1;
		gbc.fill = gbc.BOTH;
		settings.add(new JPanel(), gbc);

		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		gbc.insets = new Insets(2, 5, 2, 5);

		// BASE POINTS
		basePointsLbl = new JLabel("Base Points:");
		basePointsTF = new LevelTF(rules.getBasePoints(), 9999, 0);
		basePointsTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setBasePoints(basePointsTF.getCurrent());
					}
				});
		pointLimits.add(basePointsLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.NONE;
		gbc.weightx = 1;
		gbc.gridwidth = 3;
		pointLimits.add(basePointsTF, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.gridwidth = 1;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// DISAD POINTS
		disadPointsLbl = new JLabel("Disad Points:");
		if (HeroDesigner.getActiveTemplate().is6E()) {
			disadPointsLbl.setText("Complication Points:");
		}
		disadPointsTF = new LevelTF(rules.getDisadPoints(), 9999, 0);
		disadPointsTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setDisadPoints(disadPointsTF.getCurrent());
					}
				});
		pointLimits.add(disadPointsLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.NONE;
		gbc.weightx = 1;
		gbc.gridwidth = 3;
		pointLimits.add(disadPointsTF, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.gridwidth = 1;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// AVAIL TOTAL
		availTotalPointsResponseLbl = new JLabel(
				"If Available Total Points Exceeded:");
		availTotalPointsResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		availTotalPointsResponseCombo.setSelectedIndex(rules
				.getAvailTotalPointsResponse());
		availTotalPointsResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setAvailTotalPointsResponse(availTotalPointsResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(availTotalPointsResponseLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.NONE;
		gbc.weightx = 1;
		gbc.gridwidth = 3;
		pointLimits.add(availTotalPointsResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.gridwidth = 1;

		// AVAIL DISAD
		availDisadPointsResponseLbl = new JLabel(
				"If Available Disad Points Exceeded:");
		if (HeroDesigner.getActiveTemplate().is6E()) {
			availDisadPointsResponseLbl
					.setText("If Available Complication Points Exceeded:");
		}
		availDisadPointsResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		availDisadPointsResponseCombo.setSelectedIndex(rules
				.getAvailDisadPointsResponse());
		availDisadPointsResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setAvailDisadPointsResponse(availDisadPointsResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(availDisadPointsResponseLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.NONE;
		gbc.weightx = 1;
		gbc.gridwidth = 3;
		pointLimits.add(availDisadPointsResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.gridwidth = 1;

		// DISAD CATEGORY
		disadCategoryMaxValueLbl = new JLabel(
				"Max Points from one category of Disadvantages:");
		if (HeroDesigner.getActiveTemplate().is6E()) {
			disadCategoryMaxValueLbl
					.setText("Max Points from one category of Complications:");
		}
		disadCategoryMaxValueTF = new LevelTF(rules.getDisadCategoryMaxValue(),
				9999, 0);
		disadCategoryMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setDisadCategoryMaxValue(disadCategoryMaxValueTF
								.getCurrent());
					}
				});
		disadCategoryMaxResponseLbl = new JLabel("Action if exceeded:");
		disadCategoryMaxResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		disadCategoryMaxResponseCombo.setSelectedIndex(rules
				.getDisadCategoryMaxResponse());
		disadCategoryMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setDisadCategoryMaxResponse(disadCategoryMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(disadCategoryMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(disadCategoryMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(disadCategoryMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(disadCategoryMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// ATTACK
		attackAPMaxValueLbl = new JLabel("Max Active Points per Attack:");
		attackAPMaxValueTF = new LevelTF(rules.getAttackAPMaxValue(), 9999, 0);
		attackAPMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setAttackAPMaxValue(attackAPMaxValueTF
								.getCurrent());
					}
				});
		attackAPMaxResponseLbl = new JLabel("Action if exceeded:");
		attackAPMaxResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		attackAPMaxResponseCombo.setSelectedIndex(rules
				.getAttackAPMaxResponse());
		attackAPMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setAttackAPMaxResponse(attackAPMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(attackAPMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(attackAPMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(attackAPMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(attackAPMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// DEFENSE
		defenseAPMaxValueLbl = new JLabel("Max Active Points per Defense:");
		defenseAPMaxValueTF = new LevelTF(rules.getDefenseAPMaxValue(), 9999, 0);
		defenseAPMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setDefenseAPMaxValue(defenseAPMaxValueTF
								.getCurrent());
					}
				});
		defenseAPMaxResponseLbl = new JLabel("Action if exceeded:");
		defenseAPMaxResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		defenseAPMaxResponseCombo.setSelectedIndex(rules
				.getDefenseAPMaxResponse());
		defenseAPMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setDefenseAPMaxResponse(defenseAPMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(defenseAPMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(defenseAPMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(defenseAPMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(defenseAPMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// // CHARACTERISTIC
		// characteristicMaxValueLbl = new JLabel("Max Points in
		// Characteristics:");
		// characteristicMaxValueTF = new
		// LevelTF(rules.getCharacteristicMaxValue(), 9999, 0);
		// characteristicMaxValueTF.getDocument().addDocumentListener(new
		// DocumentListener() {
		// public void changedUpdate(DocumentEvent e) {
		// rules.setCharacteristicMaxValue(characteristicMaxValueTF.getCurrent());
		// }
		// public void insertUpdate(DocumentEvent e) {
		// rules.setCharacteristicMaxValue(characteristicMaxValueTF.getCurrent());
		// }
		// public void removeUpdate(DocumentEvent e) {
		// rules.setCharacteristicMaxValue(characteristicMaxValueTF.getCurrent());
		// }
		// });
		// characteristicMaxResponseLbl = new JLabel("Action if exceeded:");
		// characteristicMaxResponseCombo = new JComboBox(new String[] {
		// "Ignore", "Warn", "Do not allow" });
		// characteristicMaxResponseCombo.setSelectedIndex(rules.getCharacteristicMaxResponse());
		// characteristicMaxResponseCombo.addItemListener(new ItemListener() {
		// public void itemStateChanged(ItemEvent e) {
		// rules.setCharacteristicMaxResponse(characteristicMaxResponseCombo.getSelectedIndex());
		// }
		// });
		// pointLimits.add(characteristicMaxValueLbl, gbc);
		// gbc.gridx = 1;
		// gbc.anchor = gbc.WEST;
		// gbc.fill = gbc.HORIZONTAL;
		// gbc.weightx = 1;
		// pointLimits.add(characteristicMaxValueTF, gbc);
		// gbc.gridx = 2;
		// gbc.weightx = 0;
		// gbc.fill = gbc.NONE;
		// gbc.anchor = gbc.EAST;
		// pointLimits.add(characteristicMaxResponseLbl, gbc);
		// gbc.gridx = 3;
		// gbc.anchor = gbc.WEST;
		// pointLimits.add(characteristicMaxResponseCombo, gbc);
		// gbc.gridy++;
		// gbc.gridx = 0;
		// gbc.anchor = gbc.EAST;
		// gbc.weightx = 0;
		// gbc.fill = gbc.NONE;

		// SKILL
		skillMaxValueLbl = new JLabel("Max Points in Skills:");
		skillMaxValueTF = new LevelTF(rules.getSkillMaxValue(), 9999, 0);
		skillMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setSkillMaxValue(skillMaxValueTF.getCurrent());
					}
				});
		skillMaxResponseLbl = new JLabel("Action if exceeded:");
		skillMaxResponseCombo = new JComboBox(new String[] { "Ignore", "Warn",
				"Do not allow" });
		skillMaxResponseCombo.setSelectedIndex(rules.getSkillMaxResponse());
		skillMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setSkillMaxResponse(skillMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(skillMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(skillMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(skillMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(skillMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// PERK
		perkMaxValueLbl = new JLabel("Max Points in Perks:");
		perkMaxValueTF = new LevelTF(rules.getPerkMaxValue(), 9999, 0);
		perkMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setPerkMaxValue(perkMaxValueTF.getCurrent());
					}
				});
		perkMaxResponseLbl = new JLabel("Action if exceeded:");
		perkMaxResponseCombo = new JComboBox(new String[] { "Ignore", "Warn",
				"Do not allow" });
		perkMaxResponseCombo.setSelectedIndex(rules.getPerkMaxResponse());
		perkMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setPerkMaxResponse(perkMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(perkMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(perkMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(perkMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(perkMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// TALENT
		talentMaxValueLbl = new JLabel("Max Points in Talents:");
		talentMaxValueTF = new LevelTF(rules.getTalentMaxValue(), 9999, 0);
		talentMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setTalentMaxValue(talentMaxValueTF.getCurrent());
					}
				});
		talentMaxResponseLbl = new JLabel("Action if exceeded:");
		talentMaxResponseCombo = new JComboBox(new String[] { "Ignore", "Warn",
				"Do not allow" });
		talentMaxResponseCombo.setSelectedIndex(rules.getTalentMaxResponse());
		talentMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setTalentMaxResponse(talentMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(talentMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(talentMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(talentMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(talentMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// MARTIAL ARTS
		maneuverMaxValueLbl = new JLabel("Max Points in Martial Arts:");
		maneuverMaxValueTF = new LevelTF(rules.getManeuverMaxValue(), 9999, 0);
		maneuverMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setManeuverMaxValue(maneuverMaxValueTF
								.getCurrent());
					}
				});
		maneuverMaxResponseLbl = new JLabel("Action if exceeded:");
		maneuverMaxResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		maneuverMaxResponseCombo.setSelectedIndex(rules
				.getManeuverMaxResponse());
		maneuverMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setManeuverMaxResponse(maneuverMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(maneuverMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(maneuverMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(maneuverMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(maneuverMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// POWER
		powerMaxValueLbl = new JLabel("Max Points in Powers:");
		powerMaxValueTF = new LevelTF(rules.getPowerMaxValue(), 9999, 0);
		powerMaxValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setPowerMaxValue(powerMaxValueTF.getCurrent());
					}
				});
		powerMaxResponseLbl = new JLabel("Action if exceeded:");
		powerMaxResponseCombo = new JComboBox(new String[] { "Ignore", "Warn",
				"Do not allow" });
		powerMaxResponseCombo.setSelectedIndex(rules.getPowerMaxResponse());
		powerMaxResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setPowerMaxResponse(powerMaxResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(powerMaxValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(powerMaxValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(powerMaxResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(powerMaxResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// EQUIPMENT
		equipmentCostValueLbl = new JLabel("Max Total Value in Equipment:");
		equipmentCostValueTF = new LevelTF(rules.getEquipmentCostValue(), 9999,
				0);
		equipmentCostValueTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setEquipmentCostValue(equipmentCostValueTF
								.getCurrent());
					}
				});
		equipmentCostResponseLbl = new JLabel("Action if exceeded:");
		equipmentCostResponseCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		equipmentCostResponseCombo
				.setSelectedIndex(rules.getPowerMaxResponse());
		equipmentCostResponseCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setEquipmentCostResponse(equipmentCostResponseCombo
						.getSelectedIndex());
			}
		});
		pointLimits.add(equipmentCostValueLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.weightx = 1;
		pointLimits.add(equipmentCostValueTF, gbc);
		gbc.gridx = 2;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;
		gbc.anchor = gbc.EAST;
		pointLimits.add(equipmentCostResponseLbl, gbc);
		gbc.gridx = 3;
		gbc.anchor = gbc.WEST;
		pointLimits.add(equipmentCostResponseCombo, gbc);
		gbc.gridy++;
		gbc.gridx = 0;
		gbc.anchor = gbc.EAST;
		gbc.weightx = 0;
		gbc.fill = gbc.NONE;

		// FILLER
		gbc.gridwidth = gbc.REMAINDER;
		gbc.fill = gbc.BOTH;
		gbc.weightx = 1;
		gbc.weighty = 1;
		pointLimits.add(new JPanel(), gbc);

		// reset the equipment values...
		equipmentAllowedCB.doClick();
		equipmentAllowedCB.doClick();
		equipmentAllowedCB.setSelected(rules.isEquipmentAllowed());

		// RULES
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.HORIZONTAL;
		gbc.insets = new Insets(3, 3, 3, 3);

		generalPanel = new JPanel(new GridBagLayout());
		generalPanel.setBorder(BorderFactory.createTitledBorder("General"));
		multiplierAllowedCB = new JCheckBox("Allow Cost Multipliers");
		multiplierAllowedCB.setSelected(rules.multiplierAllowed());
		multiplierAllowedCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setMultiplierAllowed(multiplierAllowedCB.isSelected());
			}
		});
		generalPanel.add(multiplierAllowedCB, new GridBagConstraints(0, 0, 1,
				1, 1, 0, GridBagConstraints.WEST, GridBagConstraints.NONE,
				new Insets(3, 3, 3, 3), 0, 0));
		rulesPanel.add(generalPanel, gbc);
		gbc.gridy++;

		languageFamiliarityPanel = new JPanel();
		languageFamiliarityPanel.setLayout(new BoxLayout(
				languageFamiliarityPanel, BoxLayout.Y_AXIS));
		languageFamiliarityPanel.setBorder(BorderFactory
				.createTitledBorder("Languages"));
		useLanguageFamiliarityChartCB = new JCheckBox(
				"Use Language Familiarity Chart");
		useLanguageFamiliarityChartCB.setSelected(rules
				.isLanguageSimilaritiesUsed());
		useLanguageFamiliarityChartCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setLanguageSimilaritiesUsed(useLanguageFamiliarityChartCB
						.isSelected());
				if (useLanguageFamiliarityChartCB.isSelected()) {
					penalizeNoLevel1SimilarityCB.setEnabled(true);
				} else {
					penalizeNoLevel1SimilarityCB.setEnabled(false);
				}
			}
		});
		penalizeNoLevel1SimilarityCB = new JCheckBox(
				"Penalize for no 1 Point Similarity");
		penalizeNoLevel1SimilarityCB.setSelected(rules.penalizeNoLevel1());
		penalizeNoLevel1SimilarityCB.setEnabled(rules
				.isLanguageSimilaritiesUsed());
		penalizeNoLevel1SimilarityCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setPenalizeNoLevel1(penalizeNoLevel1SimilarityCB
						.isSelected());
			}
		});
		literacyFreeCB = new JCheckBox("Literacy free for all Languages");
		literacyFreeCB.setSelected(rules.isLiteracyFree());
		literacyFreeCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setLiteracyFree(literacyFreeCB.isSelected());
				nativeLiteracyFreeCB.setEnabled(!literacyFreeCB.isSelected());
			}
		});
		nativeLiteracyFreeCB = new JCheckBox(
				"Literacy free for Native Language");
		nativeLiteracyFreeCB.setSelected(rules.isNativeLiteracyFree());
		nativeLiteracyFreeCB.setEnabled(!rules.isLiteracyFree());
		nativeLiteracyFreeCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setNativeLiteracyFree(nativeLiteracyFreeCB.isSelected());
			}
		});
		languagesAsINTSkillCB = new JCheckBox("Languages as INT-based Skill");
		languagesAsINTSkillCB.setSelected(rules.useLanguagesAsINTSkill());
		languagesAsINTSkillCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setLanguagesAsINTSkill(languagesAsINTSkillCB.isSelected());
			}
		});
		languageFamiliarityPanel.add(useLanguageFamiliarityChartCB);
		languageFamiliarityPanel.add(penalizeNoLevel1SimilarityCB);
		languageFamiliarityPanel.add(literacyFreeCB);
		languageFamiliarityPanel.add(nativeLiteracyFreeCB);
		languageFamiliarityPanel.add(languagesAsINTSkillCB);
		rulesPanel.add(languageFamiliarityPanel, gbc);

		skillsPanel = new JPanel(new GridBagLayout());
		skillsPanel.setBorder(BorderFactory.createTitledBorder("Skills"));
		useSkillMaximaCB = new JCheckBox("Use Normal Skill Maxima");
		useSkillMaximaCB.setSelected(rules.getUseSkillMaxima());
		useSkillMaximaCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseSkillMaxima(useSkillMaximaCB.isSelected());
			}
		});
		useSkillMultiplierCB = new JCheckBox("Use Skill Multipliers");
		useSkillMultiplierCB.setSelected(rules.useSkillMultipliers());
		useSkillMultiplierCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setUseSkillMultipliers(useSkillMultiplierCB.isSelected());
			}
		});
		skillMaximaLimitLbl = new JLabel("Limit:");
		skillMaximaLimitTF = new LevelTF(rules.getSkillMaximaLimit(), 40, 8);
		skillMaximaLimitTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setSkillMaximaLimit(skillMaximaLimitTF
								.getCurrent());
					}
				});
		
		skillRollCalculationBaseLbl = new JLabel("Skill Roll Base:");
		skillRollCalculationDenominatorLbl = new JLabel("Skill Roll Denominator:");
		skillRollCalculationBaseTF = new LevelTF(rules.getSkillRollBase(), 99, -99);
		skillRollCalculationBaseTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setSkillRollBase(skillRollCalculationBaseTF
								.getCurrent());
					}
				});
		skillRollCalculationDenominatorTF = new LevelTF((int)rules.getSkillRollDenominator(), 99, -99);
		skillRollCalculationDenominatorTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setSkillRollDenominator(skillRollCalculationDenominatorTF
								.getCurrent());
					}
				});
		
		charRollCalculationBaseLbl = new JLabel("Characteristic Roll Base:");
		charRollCalculationDenominatorLbl = new JLabel("Characteristic Roll Denominator:");
		charRollCalculationBaseTF = new LevelTF(rules.getCharRollBase(), 99, -99);
		charRollCalculationBaseTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setCharRollBase(charRollCalculationBaseTF
								.getCurrent());
					}
				});
		charRollCalculationDenominatorTF = new LevelTF((int)rules.getCharRollDenominator(), 99, -99);
		charRollCalculationDenominatorTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						rules.setCharRollDenominator(charRollCalculationDenominatorTF
								.getCurrent());
					}
				});
		GridBagConstraints gbc2 = new GridBagConstraints();
		gbc2.gridx = 0;
		gbc2.gridy = 0;
		gbc2.weightx = 0;
		gbc2.weighty = 0;
		gbc2.anchor = gbc2.WEST;
		gbc2.fill = gbc2.NONE;
		gbc2.insets = new Insets(3, 3, 3, 3);
		skillsPanel.add(useSkillMaximaCB, gbc2);
		gbc2.gridx = 1;
		skillsPanel.add(skillMaximaLimitLbl, gbc2);
		gbc2.gridx = 2;
		gbc2.weightx = 1;
		skillsPanel.add(skillMaximaLimitTF, gbc2);
		gbc2.gridx = 0;
		gbc2.gridy++;
		gbc2.weightx=0;
		skillsPanel.add(useSkillMultiplierCB, gbc2);
		gbc2.gridy++;
		skillsPanel.add(skillRollCalculationBaseLbl, gbc2);
		gbc2.gridx=2;
		gbc2.weightx=1;
		skillsPanel.add(skillRollCalculationBaseTF, gbc2);
		gbc2.gridx=0;
		gbc2.weightx=0;
		gbc2.gridy++;
		skillsPanel.add(skillRollCalculationDenominatorLbl,gbc2);
		gbc2.gridx=2;
		gbc2.weightx=1;
		skillsPanel.add(skillRollCalculationDenominatorTF, gbc2);
		
		gbc2.gridx = 0;
		gbc2.gridy++;
		gbc2.weightx=0;
		generalPanel.add(charRollCalculationBaseLbl, gbc2);
		gbc2.gridx=2;
		gbc2.weightx=1;
		generalPanel.add(charRollCalculationBaseTF, gbc2);
		gbc2.gridx=0;
		gbc2.weightx=0;
		gbc2.gridy++;
		generalPanel.add(charRollCalculationDenominatorLbl,gbc2);
		gbc2.gridx=2;
		gbc2.weightx=1;
		generalPanel.add(charRollCalculationDenominatorTF, gbc2);
		
		gbc.gridx = 0;
		gbc.gridy++;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.anchor = gbc.WEST;
		gbc.insets = new Insets(3, 3, 3, 3);
		gbc.fill = gbc.BOTH;
		rulesPanel.add(skillsPanel, gbc);

		characteristicsPanel = new JPanel(new GridBagLayout());
		characteristicsPanel.setBorder(BorderFactory
				.createTitledBorder("Characteristics"));
		if (!HeroDesigner.getActiveTemplate().is6E()) {
			onlySellOneFiguredCB = new JCheckBox(
					"Only allow one Figured Characteristic to be sold off");
			if (rules.onlySellOneFigured()) {
				onlySellOneFiguredCB.setSelected(true);
			} else {
				onlySellOneFiguredCB.setSelected(false);
			}
			onlySellOneFiguredCB.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					rules.setOnlySellOneFigured(onlySellOneFiguredCB
							.isSelected());
				}
			});
		}
		useIncreasedDamageDifferentiationCB = new JCheckBox(
				"Use Increased Damage Differentiation on STR");
		if (rules.useIncreasedDamageDifferentiation()) {
			useIncreasedDamageDifferentiationCB.setSelected(true);
		} else {
			useIncreasedDamageDifferentiationCB.setSelected(false);
		}
		useIncreasedDamageDifferentiationCB
				.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						rules
								.setUseIncreasedDamageDifferentiation(useIncreasedDamageDifferentiationCB
										.isSelected());
					}
				});
		gbc.gridx = 0;
		gbc.gridy++;
		gbc.weightx = 1;
		gbc.weighty = 0;
		gbc.anchor = gbc.WEST;
		gbc.fill = gbc.NONE;
		gbc.insets = new Insets(3, 3, 3, 3);
		if (!HeroDesigner.getActiveTemplate().is6E()) {
			characteristicsPanel.add(onlySellOneFiguredCB, gbc);
		}
		gbc.gridy++;
		characteristicsPanel.add(useIncreasedDamageDifferentiationCB, gbc);
		gbc.gridy++;
		gbc.fill = gbc.BOTH;
		rulesPanel.add(characteristicsPanel, gbc);

		gbc2 = new GridBagConstraints();
		gbc2.gridy = 0;
		gbc2.gridx = 0;
		gbc2.anchor = gbc2.EAST;
		gbc2.weightx = 0;
		gbc2.fill = gbc2.NONE;
		gbc2.gridwidth = 1;
		gbc2.insets = new Insets(3, 3, 3, 3);
		frameworksPanel = new JPanel(new GridBagLayout());
		frameworksPanel.setBorder(BorderFactory
				.createTitledBorder("Power Frameworks"));
		linkAcrossFrameworkLbl = new JLabel(
				"Link different slots of a Power Framework:");
		linkAcrossFrameworkCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		linkAcrossFrameworkCombo.setSelectedIndex(rules
				.getLinkAcrossFramework());
		linkAcrossFrameworkCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setLinkAcrossFramework(linkAcrossFrameworkCombo
						.getSelectedIndex());
			}
		});
		frameworksPanel.add(linkAcrossFrameworkLbl, gbc2);
		gbc2.gridx = 1;
		gbc2.anchor = gbc.WEST;
		gbc2.fill = gbc.NONE;
		gbc2.weightx = 1;
		gbc2.gridwidth = 1;
		frameworksPanel.add(linkAcrossFrameworkCombo, gbc2);
		gbc2.gridy++;
		gbc2.gridx = 0;
		gbc2.anchor = gbc.EAST;
		gbc2.weightx = 0;
		gbc2.fill = gbc2.NONE;
		gbc2.gridwidth = 1;
		specialTypeInFrameworkLbl = new JLabel(
				"\"Special\" type Powers in Frameworks:");
		specialTypeInFrameworkCombo = new JComboBox(new String[] { "Ignore",
				"Warn", "Do not allow" });
		specialTypeInFrameworkCombo.setSelectedIndex(rules
				.getSpecialTypeInFramework());
		specialTypeInFrameworkCombo.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				rules.setSpecialTypeInFramework(specialTypeInFrameworkCombo
						.getSelectedIndex());
			}
		});
		frameworksPanel.add(specialTypeInFrameworkLbl, gbc2);
		gbc2.gridx = 1;
		gbc2.anchor = gbc.WEST;
		gbc2.fill = gbc.NONE;
		gbc2.weightx = 1;
		gbc2.gridwidth = 1;
		frameworksPanel.add(specialTypeInFrameworkCombo, gbc2);
		gbc2.gridy++;
		gbc2.gridx = 0;
		gbc2.anchor = gbc.EAST;
		gbc2.weightx = 0;
		gbc2.fill = gbc2.NONE;
		gbc2.gridwidth = 1;

		if (!HeroDesigner.getActiveTemplate().is6E()) {
			nonENDUsingAbilityInECLbl = new JLabel(
					"Non-END Using abilities in an Elemental Control:");
			nonENDUsingAbilityInECCombo = new JComboBox(new String[] {
					"Ignore", "Warn", "Do not allow" });
			nonENDUsingAbilityInECCombo.setSelectedIndex(rules
					.getNonENDUsingAbilityInEC());
			nonENDUsingAbilityInECCombo.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					rules.setNonENDUsingAbilityInEC(nonENDUsingAbilityInECCombo
							.getSelectedIndex());
				}
			});
			frameworksPanel.add(nonENDUsingAbilityInECLbl, gbc2);
			gbc2.gridx = 1;
			gbc2.anchor = gbc.WEST;
			gbc2.fill = gbc.NONE;
			gbc2.weightx = 1;
			gbc2.gridwidth = 1;
			frameworksPanel.add(nonENDUsingAbilityInECCombo, gbc2);
			gbc2.gridy++;
			gbc2.gridx = 0;
			gbc2.anchor = gbc.WEST;
			gbc2.weightx = 0;
			gbc2.fill = gbc2.NONE;
			gbc2.gridwidth = 2;
			automaticallyApplyNoFiguredCB = new JCheckBox(
					"Automatically Apply \"No Figured Characteristics\" to Primary Characteristics placed in Framework");
			automaticallyApplyNoFiguredCB.setSelected(rules
					.automaticallyApplyNoFigured());
			automaticallyApplyNoFiguredCB
					.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent e) {
							rules
									.setAutomaticallyApplyNoFigured(automaticallyApplyNoFiguredCB
											.isSelected());
						}
					});
			frameworksPanel.add(automaticallyApplyNoFiguredCB, gbc2);
		}
		gbc.gridy++;
		rulesPanel.add(frameworksPanel, gbc);

		gbc2.gridy = 0;
		gbc2.gridx = 0;
		gbc2.anchor = gbc2.WEST;
		gbc2.weightx = 1;
		gbc2.fill = gbc2.NONE;
		gbc2.gridwidth = 1;
		gbc2.insets = new Insets(3, 3, 3, 3);
		standardEffectPanel = new JPanel(new GridBagLayout());
		standardEffectPanel.setBorder(BorderFactory
				.createTitledBorder("Standard Effect"));
		standardEffectAllowedCB = new JCheckBox("Standard Effect allowed");
		standardEffectAllowedCB.setSelected(rules.isStandardEffectAllowed());
		standardEffectAllowedCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setStandardEffectAllowed(standardEffectAllowedCB
						.isSelected());
				defaultStandardEffectCB.setEnabled(standardEffectAllowedCB
						.isSelected());
			}
		});
		standardEffectPanel.add(standardEffectAllowedCB, gbc2);
		gbc2.gridy++;
		defaultStandardEffectCB = new JCheckBox(
				"Standard Effect selected by default");
		defaultStandardEffectCB.setEnabled(rules.isStandardEffectAllowed());
		defaultStandardEffectCB.setSelected(rules.defaultStandardEffect());
		defaultStandardEffectCB.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				rules.setDefaultStandardEffect(defaultStandardEffectCB
						.isSelected());
			}
		});
		standardEffectPanel.add(defaultStandardEffectCB, gbc2);

		gbc.gridy++;
		rulesPanel.add(standardEffectPanel, gbc);

		gbc2.gridy = 0;
		gbc2.gridx = 0;
		gbc2.anchor = gbc2.WEST;
		gbc2.weightx = 1;
		gbc2.fill = gbc2.NONE;
		gbc2.gridwidth = 1;
		gbc2.insets = new Insets(3, 3, 3, 3);
		if (!HeroDesigner.getActiveTemplate().is6E()) {
			powersPanel = new JPanel(new GridBagLayout());
			powersPanel.setBorder(BorderFactory.createTitledBorder("Powers"));
			if (!HeroDesigner.getActiveTemplate().is6E()) {
				useExpandedGrowthChartCB = new JCheckBox(
						"Use Expanded Growth Chart (from The Ultimate Brick)");
				useExpandedGrowthChartCB.setSelected(rules
						.useExpandedGrowthChart());
				useExpandedGrowthChartCB
						.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent e) {
								rules
										.setUseExpandedGrowthChart(useExpandedGrowthChartCB
												.isSelected());
							}
						});
				powersPanel.add(useExpandedGrowthChartCB, gbc2);
			}
			gbc2.gridy++;

			gbc.gridy++;
			rulesPanel.add(powersPanel, gbc);
		}
		// FILLER
		gbc.gridy++;
		gbc.weighty = 1;
		gbc.fill = gbc.BOTH;
		rulesPanel.add(new JPanel(), gbc);
	}

	private void setEquipmentCostExample() {
		if (equipmentCostValueLbl != null) {
			equipmentCostValueLbl.setText("Max Total Value in Equipment ("
					+ rules.getEquipmentCostUnits() + "):");
		}
		equipmentCostConversionLbl.setText(" # CU per "
				+ (rules.isEquipmentUnitsPrefix() ? rules
						.getEquipmentCostUnits() : "")
				+ "1"
				+ (rules.isEquipmentUnitsPrefix() ? "" : rules
						.getEquipmentCostUnits()) + ":");
		String example = "";
		if (rules.isEquipmentUnitsPrefix()) {
			example += rules.getEquipmentCostUnits();
		}
		try {
			double cost = 100d / rules.getEquipmentCostConversion();
			BigDecimal bd = new BigDecimal(cost);
			bd = bd.setScale(rules.getEquipmentCostDecimalPlaces(),
					bd.ROUND_HALF_UP);
			example += bd.toString();
			if (!rules.isEquipmentUnitsPrefix()) {
				example += rules.getEquipmentCostUnits();
			}
			equipmentCostExampleLbl.setText("example:  100 CU = " + example);
		} catch (Exception exp) {

		}
	}

}